* rt-contrib.prg
* v1.0
*
* Forecast unemployment rate using real-time data

calendar 1951 1 12
allocate 2100:12

declare integer FIRSTOBS LASTOBS ESTEND ESTBEG FCBEG FCEND FCLEN

open data input.csv
data(format=cdf, org=col) / E U U_S
close data

** locate last observation for UR
set ur = U/(U+E)
inquire(series=ur) FIRSTOBS LASTOBS
set urdata = ur

*************************************************
*** PARAMETERS FOR ESTIMATION AND FORECASTING ***
*************************************************
compute NLAGS=2;                    * Number of lags in VAR
compute ESTEND=LASTOBS;             * End date for VAR estimation
compute ESTBEG=ESTEND-179;          * Start date for VAR estimation
compute FCLEN=24;                   * Forecast length
compute FCBEG=ESTEND+1;             * Starting date for UR forecast
compute FCEND=FCBEG+FCLEN;          * Last date for which forecasts are desired

****************************************
*** COMPUTE HAZARD RATES FROM STOCKS ***
****************************************
* adjust for redesign
set orig_U_s = U_s
set U_s * 1994:1 = orig_U_s
set U_s 1994:2 * = 1.1549*orig_U_s
*
set bigF = 1 - ((U{-1} - U_s{-1})/U)
set f = -log(1-bigF)
* set up s series
set s = %na
* iterate
do i = FIRSTOBS,LASTOBS-1
  compute Ei = E(i)
  compute Ui = U(i)
  compute U1i = U(i+1)
  compute fi = f(i)
  nonlin x
  * guess average s
  compute xs = 0.0345
  * transform xs in [0,1] to x in [-inf,inf]
  compute x = log(xs/(1-xs))
  compute value = 0.0
  find(method=genetic,iterations=100,subiterations=100000,cvcrit=0.0001,noprint) root value
    * x in [-inf,inf]; xs in [0,1]
    compute xs = exp(x)/(1+exp(x))
    compute value = U1i - (Ui+Ei)*xs*(1-exp(-fi-xs))/(fi+xs) - Ui*exp(-fi-xs)
  end find
  set s i i = xs
end do
*
*print(picture="#.#####") / s f ur

***************************************
*** ESTIMATE AND SIMULATE VAR MODEL ***
***************************************
set trend = T
* logs of variables
set ls = log(s{1})
set lf = log(f{1})
set lur = log(ur)
set dlur = log(ur/ur{1})

* VAR
system(model=ssur2)
variables ls lf dlur
lags 1 to NLAGS
det constant
end(system)
*
estimate(model=ssur2) ESTBEG ESTEND
forecast(model=ssur2,from=FCBEG,to=FCEND+1,results=fcasts)

******************
*** CONSTANT s ***
******************
set s_f = s
set f_f = f
* add in flows forecats
set s_f FCBEG-1 FCEND = s(LASTOBS-1)
set f_f FCBEG-1 FCEND = exp(fcasts(2){-1})
* steady state unemployment rate
set ssur_f = s_f/(s_f+f_f)
* convergence speed
set beta = 1-exp(-f_f-s_f)
set ur_f = urdata
* iterate to create UR forecast
do t=FCBEG-1,FCEND
  set ur_f t t = beta(t)*ssur_f(t-1) + (1-beta(t))*ur_f(t-1)
end do
set ur_f * lastobs = urdata
*
print(picture="#.#####") FCBEG-1 FCEND s_f f_f ssur_f ur_f

******************
*** CONSTANT f ***
******************
set s_s = s
set f_s = f
* add in flows forecats
set s_s FCBEG-1 FCEND = exp(fcasts(1){-1})
set f_s FCBEG-1 FCEND = f(LASTOBS-1)
* steady state unemployment rate
set ssur_s = s_s/(s_s+f_s)
* convergence speed
set beta = 1-exp(-f_s-s_s)
set ur_s = urdata
* iterate to create UR forecast
do t=FCBEG-1,FCEND
  set ur_s t t = beta(t)*ssur_s(t-1) + (1-beta(t))*ur_s(t-1)
end do
set ur_s * lastobs = urdata
*
print(picture="#.#####") FCBEG-1 FCEND s_s f_s ssur_s ur_s

********************************
*** STORE SERIES TO CSV FILE ***
********************************
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) / s_s f_s ur_s s_f f_f ur_f
close copy
